/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.objects.blocks.plants.BlockPlantTFC;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockFlowerPotTFC
extends Block {
    protected static final AxisAlignedBB FLOWER_POT_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875);
    private static final Map<Plant, BlockFlowerPotTFC> MAP = new HashMap<Plant, BlockFlowerPotTFC>();
    public final Plant plant;

    public static BlockFlowerPotTFC get(Plant plant) {
        return MAP.get((Object)plant);
    }

    public BlockFlowerPotTFC(Plant plant) {
        super(Material.field_151594_q);
        this.plant = plant;
        if (MAP.put(plant, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FLOWER_POT_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? super.func_193383_a(worldIn, state, pos, face) : BlockFaceShape.UNDEFINED;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.clear();
        drops.add((Object)new ItemStack((Block)BlockPlantTFC.get(this.plant)));
        drops.add((Object)new ItemStack(Items.field_151162_bE));
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState downState = worldIn.func_180495_p(pos.func_177977_b());
        return super.func_176196_c(worldIn, pos) && (downState.func_185896_q() || downState.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (!worldIn.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
            worldIn.func_175698_g(pos);
        }
    }
}

